//***************************************************************************
/// Test of PCF8574 IO expander and PCF8575 ET-BIG 7X2
//
//  MCU : Mega1280 (5V)
//  Port IO : D21 = SCL ,D20 =SDA
//***************************************************************************

//Include Wire library
#include <Wire.h>

#define DEVICE_1 0x20     //PCF8574A=0x38 and PCF8574=0x20  by A0,A1,A2=0
#define DEVICE_2 0x21     //PCFf8575=0x21(010 0aaa) ET-BIG Clock by A0=1


void setup()
{
    Wire.begin(); 
}

void loop()
{
   byte m,k ;
   byte SegCode[] = {0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x6F};   //7-Segment Code =0,1,2,3,4,5,6,7,8,9

  while(1)
  {
     for(m = 0; m<10; m++)            //Count IO PCF8574
      {
        k  = (~m) & 0x0F         ; //4bit Low count 0-9 for LED common Anode   Act=0
        k |=  (m<<4) & 0xF0     ; //4bit High count 0-9 for LED common Kathode Act=1
               
        Wr_PCF8574(DEVICE_1,k);        //PCF857  
       // delay(200); 
    
      

    //-------------------------------------------
    // for(m = 0; m<10; m++)
      //{
      
        Wr_PCF8575(DEVICE_2,SegCode[m],SegCode[9-m]);    //PCF8575  -Seg LOW
       
        delay(1000); 
  
     }
  }  //While  
}   //Loop



//****Write a byte to the PCF8574****

void Wr_PCF8574(byte address, byte db) 
{
 Wire.beginTransmission(address);
 Wire.write(db); //7-seg 8bit High colum Left
 Wire.endTransmission(); 
}

//****Write a byte to the PCF8575****

void Wr_PCF8575(byte address, byte Ldata,byte Hdata ) 
{
 Wire.beginTransmission(address);
 Wire.write(Ldata); //7-seg 8bit Low colum Right
 Wire.write(Hdata); //7-seg 8bit High colum Left
 Wire.endTransmission(); 
}


//Read a byte from the IO expander
/*
byte IOexpanderRead(int address) 
{
 byte _data;
 Wire.requestFrom(address, 1);
 if(Wire.available()) {
   _data = Wire.read();
 }
 return _data;
}
*/
